#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <math.h>
#include "bent6.h"
#include "registers.h"

uint16_t N = 2000;

uint64_t M6  = 0x7FFFFFFLL;
uint64_t M7  = 0xFFFFFFFLL;
uint64_t M9  = 0x3FFFFFFFLL;
uint64_t M10 = 0x7FFFFFFFLL;
uint64_t M11 = 0xFFFFFFFFLL;
uint64_t M12 = 0x1FFFFFFFFLL;

/************************************************************************************/
/** Concept Cipher Cipherbent6: six NLFSR combined by a 6-variable bent function   **/
/**   - the 6 NLFSRs are those used in Achterbahn (deg. 27, 28, 30, 31, 32, 33)    **/
/**   - bent function x1x4 + x2x5 + x3x6 (Rothaus, 1976)                           **/
/**   - Key size 181 bits                                                          **/
/************************************************************************************/
int main(int argc, char * argv[])
 { 
  uint64_t i, j, k;
  uint64_t reg6, reg7, reg9, reg10, reg11, reg12;
  uint8_t * outseq, fb, index;

  /** 181-bit key (put your own value hereafter) **/
  reg6  = 0x453A5FLL;
  reg7  = 0x564B60LL;
  reg9  = 0x675C71LL;
  reg10 = 0x1786D82LL;
  reg11 = 0x2897E93LL;
  reg12 = 0x59A8FA4LL;

  outseq = (uint8_t *)calloc(N, sizeof(uint8_t));

  printf("uint8_t outseq[%u] = {", N);
  for(i = 0L;i < N;i++)
   {
    index = ((reg6 & 1) | ((reg7 & 1) << 1) | ((reg9 & 1) << 2) | ((reg10 & 1) << 3) | ((reg11 & 1) << 4) |((reg12 & 1) << 5));
    outseq[i] = fbent6[index];
    if(i && ((i % 32) == 0)) printf("\n                         ");
    printf("%1u,", outseq[i]);
    
    fb = fb6(reg6);
    reg6 >>= 1;
    reg6 |= ((uint64_t)(fb) << 26);
    reg6 &= M6;

    fb = fb7(reg7);
    reg7 >>= 1;
    reg7 |= ((uint64_t)(fb) << 27);
    reg7 &= M7;

    fb = fb9(reg9);
    reg9 >>= 1;
    reg9 |= ((uint64_t)(fb) << 29);
    reg9 &= M9;

    fb = fb10(reg10);
    reg10 >>= 1;
    reg10 |= ((uint64_t)(fb) << 30);
    reg10 &= M10;

    fb = fb11(reg11);
    reg11 >>= 1;
    reg11 |= ((uint64_t)(fb) << 31);
    reg11 &= M11;

    fb = fb12(reg12);
    reg12 >>= 1;
    reg12 |= ((uint64_t)(fb) << 32);
    reg12 &= M12;
   }
  printf("\n");
  exit(0);
 } 
